<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\widgets\FileInput;
use yii\helpers\Url;

/* @var $this yii\web\View */
/* @var $model backend\models\Sik */
/* @var $form yii\widgets\ActiveForm */
$model->created_at = ($model->created_at) ? $model->created_at : time();
?>

<div class="sik-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'created_at')->textInput(['value'=> date('Y-m-d')])->label('Day') ?>

    <?= $form->field($model, 'date')->textInput() ?>

    <?= $form->field($model, 'key')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'csvcontent')->textarea(['rows' => 6]) ?>

    
	    <?=FileInput::widget([
	        'name' => 'file',
	        'options' => [
	            'multiple' => true, 
	            'id' => 'scvFileLoad'
	        ],
	        'pluginOptions' => [
	            'allowedFileExtensions' => ['csv'],
	            'previewFileType' => 'any', 
	            'showUpload' => false, 
	            'showRemove' => false, 
	            'initialPreviewAsData' => true, 
	            'overwriteInitial' => true,
	            "uploadUrl" => Url::to(['/upload']),
	            'msgUploadBegin' => '',
	            'msgUploadThreshold' => '',
	            'msgProgress' => '',
	            'msgLoading' => '',
	            'msgPendingTime' => '',
	            'msgCalculatingTime' => '',
	            'msgUploadEnd' => 'Done',
	            'dropZoneClickTitle'=>'',
	            "uploadAsync" => true,
	            "browseOnZoneClick"=>false,
	            'showPreview' => false,
	            'showUploadStats' => false,
	            'showCancel' => false,
	            'fileActionSettings' => [
	                'showZoom' => false,
	                'showRemove' => false,
	                'showUpload' => false,
	            ],
	            'maxFileCount' => 20, 'maxFileSize' => 1000000, 'msgPlaceholder' => '',
	        ],
	        'pluginEvents' => [
	            'filebatchselected' => 'function() {
	             $(this).fileinput("upload");
	             }',

	        ],
	    ]);
	    ?>
    

	<?php if (!Yii::$app->request->isAjax){ ?>
	  	<div class="form-group">
	        <?= Html::submitButton($model->isNewRecord ? 'Create' : 'Update', ['class' => $model->isNewRecord ? 'btn btn-success' : 'btn btn-primary']) ?>
	    </div>
	<?php } ?>

    <?php ActiveForm::end(); ?>
    
</div>
